//Originally created by _creepersbane#2074
//Adapted to work with all games by Grossley
//Adapted to GMS 2.3+ by Space Core/Jacky720

EnsureDataLoaded();

var obj = Data.GameObjects.ByName("obj_roomselector");

if(obj == null) {
    obj = new UndertaleGameObject() { Name = Data.Strings.MakeString("obj_roomselector"), Persistent = true };
    Data.GameObjects.Add(obj);
}

UndertaleModLib.Compiler.CodeImportGroup importGroup = new(Data);

if (Data.GeneralInfo.Name.Content.StartsWith("UNDERTALE")) {
    // Remove existing F3 handler to avoid accidentally 
    // creating system_information_962
    importGroup.QueueReplace(Data.GameObjects.ByName("obj_time").EventHandlerFor(EventType.KeyPress, (uint)114, Data), "");
}

bool gms2 = Data.IsGameMaker2();

var entry_room = Data.GeneralInfo.RoomOrder[0].Resource;
var object_list = entry_room.GameObjects;
bool add_to_room = true;

if(gms2) {
    UndertaleRoom.Layer target_layer = null;
    foreach(var layer in entry_room.Layers) {
        if(layer.LayerType == UndertaleRoom.LayerType.Instances) {
            foreach(var layer_obj in layer.InstancesData.Instances) {
                if(layer_obj.ObjectDefinition == obj) {
                    add_to_room = false;
                    break;
                }
            }
            if(!add_to_room) {
                break;
            }
            if(target_layer == null || target_layer.LayerDepth > layer.LayerDepth) {
                target_layer = layer;
            }
        }
    }
    
    if(add_to_room) {
        if(target_layer == null) {
            uint layer_id = 0;
            foreach(var room in Data.Rooms) {
                if (room is null)
                    continue;
                foreach(var layer in room.Layers) {
                    if(layer.LayerId > layer_id) {
                        layer_id = (uint)layer.LayerId;
                    }
                }
            }
            
            target_layer = new UndertaleRoom.Layer() {
                LayerName = Data.Strings.MakeString("Room_Selector_Layer"),
                Data = new UndertaleRoom.Layer.LayerInstancesData(),
                LayerType = UndertaleRoom.LayerType.Instances,
                LayerDepth = -1000,
                LayerId = layer_id,
                IsVisible = true
            };
            
            entry_room.Layers.Add(target_layer);
        }
        var obj_to_add = new UndertaleRoom.GameObject() {
            InstanceID = Data.GeneralInfo.LastObj++,
            ObjectDefinition = obj,
            X = 0, Y = 0
        };
        target_layer.InstancesData.Instances.Add(obj_to_add);
        object_list.Add(obj_to_add);
    }
}
else {

    foreach(var room_obj in object_list) {
        if(room_obj.ObjectDefinition == obj) {
            add_to_room = false;
            break;
        }
    }

    if(add_to_room) {
        object_list.Add(new UndertaleRoom.GameObject() {
            InstanceID = Data.GeneralInfo.LastObj++,
            ObjectDefinition = obj,
            X = 0, Y = 0
        });
    }
}



importGroup.QueueReplace(obj.EventHandlerFor(EventType.Create, Data), @"
if (instance_number(object_index) > 1)
{
    instance_destroy(id, false)
    exit
}
selector_active = 0
selector_initialized = 0
suggestions = ds_list_create()
valid_chars = ""abcdefghijklmnopqrstuvwxyz_0123456789""
dest_room = room_get_name(room)
num_suggestions = 0
case_sensitive = 1
max_selection = 0
update_cursor = 1
cursor_timer = 30
show_cursor = 1
image_alpha = 0
selection = 0
update = 1
scale = 1
fnt = -4
len = 0
ss = -4" 
+ (!Data.IsVersionAtLeast(2, 3) 
  ? "for (i = room_first; i <= room_last; i++)"
  : "for (i = 0; room_exists(i); i++)")
+ @"
{
    if room_exists(i)
        room_names[i] = (((room_get_name(i) + "" ("") + string(i)) + "")"")
    else
        room_names[i] = -4
}
// for 2.3
myroom_last = i
ww = -1
hh = -1
xx = 0
yy = 0
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Step, Data), @"
if selector_active
{
    global.interact = 1
    if exiting
    {
        image_alpha -= 0.1
        if (image_alpha <= 0)
            event_user(1)
    }
    else
    {
        if (image_alpha < 1)
            image_alpha += 0.1
    
        if update
        {
            ds_list_clear(suggestions)
            tmp_suggestions[0] = -4
            num_suggestions = 0
            positions[0] = -1
            roomid = -1
            if (dest_room != """" && dest_room == string_digits(dest_room))
                roomid = real(dest_room)"
            + (!Data.IsVersionAtLeast(2, 3)
              ? "for (i = room_first; i <= room_last; i++)"
              : "for (i = 0; i < myroom_last; i++)")
            + @"
            {
                if is_string(room_names[i])
                {
                    if case_sensitive
                        pos = string_pos(dest_room, room_names[i])
                    else
                        pos = string_pos(string_lower(dest_room), string_lower(room_names[i]))
                    if (roomid != i && pos > 0)
                    {
                        tmp_suggestions[num_suggestions] = i
                        positions[num_suggestions] = pos
                        num_suggestions++
                    }
                }
            }
            for (k = 0; k < num_suggestions; k++)
            {
                for (j = k; j < num_suggestions; j++)
                {
                    if (positions[k] > positions[j] || (positions[k] == positions[j] && room_names[tmp_suggestions[k]] > room_names[tmp_suggestions[j]]))
                    {
                        tmp = positions[k]
                        positions[k] = positions[j]
                        positions[j] = tmp
                        tmp = tmp_suggestions[k]
                        tmp_suggestions[k] = tmp_suggestions[j]
                        tmp_suggestions[j] = tmp
                    }
                }
            }
            if (roomid >= room_first && roomid <= room_last)
                ds_list_add(suggestions, room_names[roomid])
            for (i = 0; i < num_suggestions; i++)
                ds_list_add(suggestions, room_names[tmp_suggestions[i]])
            if update_cursor
            {
                cursor_timer = 30
                show_cursor = 1
            }
            update_cursor = 1
            update = 0
        }
        num_suggestions = ds_list_size(suggestions)
        len = string_length(dest_room)
        dir = (keyboard_check(vk_down) - keyboard_check(vk_up))
        if (dir != 0)
        {
            keyboard_clear(vk_down)
            keyboard_clear(vk_up)
            selection += dir
        }
        if (keyboard_lastchar != """")
        {
            if (string_pos(string_lower(keyboard_lastchar), valid_chars) > 0)
            {
                dest_room += keyboard_lastchar
                update = 1
            }
            keyboard_lastchar = """"
        }
        if keyboard_check(vk_backspace)
        {
            if (len > 0)
            {
                if (len == 1)
                    dest_room = """"
                else
                    dest_room = string_copy(dest_room, 1, (len - 1))
                update = 1
            }
            keyboard_clear(vk_backspace)
        }
        if (selection >= max_selection)
            selection = (max_selection - 1)
        if (selection < 0)
            selection = 0
        if keyboard_check(vk_return)
        {
            keyboard_clear(vk_return)
            if (num_suggestions > 0)
            {
                name = ds_list_find_value(suggestions, selection)
                name = string_copy(name, 1, (string_pos("" "", name) - 1))
                roomid = asset_get_index(name)
                if room_exists(roomid)
                {
                    instance_activate_all()
                    global.interact = 0
                    if (room == roomid)
                    {
                        selector_active = false
                        selector_initialized = false;
                        sel_ever_activated = true;
                        room_restart()
                    }
                    else
                    {
                        audio_stop_all()
                        selector_active = false
                        selector_initialized = false;
                        sel_ever_activated = true;
                        room_goto(roomid)
                    }
                }
            }
        }
        if (keyboard_check(vk_escape) || keyboard_check(vk_f3))
        {
            keyboard_clear(vk_escape)
            keyboard_clear(vk_f3)
            exiting = 1
        }
        if keyboard_check(vk_tab)
        {
            keyboard_clear(vk_tab)
            case_sensitive ^= 1
            update_cursor = 0
            update = 1
        }
    }
}
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Draw, (uint)64, Data), @"
if selector_active
{
    if sprite_exists(ss)
        draw_sprite_ext(ss, 0, xx, yy, scale, scale, 0, c_white, 1)
    draw_set_alpha((image_alpha / 2))
    draw_set_font(fnt)
    draw_set_color(c_black)
    draw_rectangle(xx, yy, (xx + ww), (yy + hh), false)
    draw_set_alpha(image_alpha)
    draw_set_halign(fa_center)
    if (num_suggestions < 1)
        draw_set_color(c_red)
    else
        draw_set_color(c_white)
    textx = (xx + (ww / 2))
    texty = (yy + (hh / 3))
    draw_text(textx, texty, dest_room)
    draw_set_color(c_white)
    if show_cursor
        draw_text(((textx + (string_width(dest_room) / 2)) + 2), texty, ""|"")
    texty += (string_height((dest_room + ""|"")) + 3)
    draw_set_color(c_white)
    draw_rectangle((textx - (ww / 4)), texty, (textx + (ww / 4)), (texty + 3), false)
    texty += 6
    for (i = 0; i < num_suggestions; i++)
    {
        max_selection = (i + 1)
        name = ds_list_find_value(suggestions, i)
        if ((texty + string_height(name)) > (yy + hh))
        {
            max_selection--
            i = num_suggestions
        }
        else
        {
            if (i == selection)
                draw_set_color(c_yellow)
            else
                draw_set_color(c_white)
            draw_text(textx, texty, name)
            texty += (string_height(name) + 3)
        }
    }
    if (max_selection > num_suggestions)
        max_selection = num_suggestions
    if (cursor_timer-- < 1)
    {
        cursor_timer = 30
        show_cursor ^= 1
    }
    draw_set_halign(fa_left)
    draw_set_color(c_white)
    results_str = ""???""
    if (num_suggestions > 0)
        results_str = string(num_suggestions)
    else
        results_str = ""No ""
    results_str += "" result""
    if (num_suggestions != 1)
        results_str += ""s""
    if (max_selection != num_suggestions)
        results_str += (("" ("" + string(max_selection)) + "" shown)"")
    draw_text((xx + 10), (yy + 10), results_str)
    casing = ""sensitive""
    if (!case_sensitive)
        casing = (""in"" + casing)
    draw_text((xx + 10), ((yy + 13) + string_height(results_str)), ((""Case-"" + casing) + "" (toggle with Tab)""))
    draw_set_alpha(1)
}
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Destroy, Data), @"
ds_list_destroy(suggestions)
sprite_delete(ss)
font_delete(fnt)
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Other, (uint)5, Data), @"
if selector_active
    event_user(1)
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.KeyPress, (uint)114, Data), @"
if (!selector_active)
    event_user(0)
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Other, (uint)10, Data), @"
selector_active = 1
if (!selector_initialized)
    fnt = font_add(""8bitoperator_jve.ttf"", 24, 0, 0, 32, 127)
dest_room = room_get_name(room)
ss_width = surface_get_width(application_surface)
ss_height = surface_get_height(application_surface)
ss = sprite_create_from_surface(application_surface, 0, 0, ss_width, ss_height, false, false, 0, 0)
scale = min((window_get_width() / ss_width), (window_get_height() / ss_height))
instance_deactivate_all(true)
selector_initialized = 1
hh = (ss_height * scale)
ww = (ss_width * scale)
keyboard_lastchar = """"
display_set_gui_size(ww, hh)
ds_list_clear(suggestions)
keyboard_clear(vk_f3)
global.interact = 1
image_alpha = 0
exiting = 0
update = 1
");

importGroup.QueueReplace(obj.EventHandlerFor(EventType.Other, (uint)11, Data), @"
display_set_gui_size(-1, -1)
instance_activate_all()
keyboard_clear(vk_f3)
sprite_delete(ss)
global.interact = 0
selector_active = 0
exiting = 0
");

importGroup.Import();

string version;
if (Data.IsVersionAtLeast(2, 3))
    version = "2.3";
else if (gms2)
    version = "2";
else
    version = "1";

ScriptMessage(@$"Successfully applied for Gamemaker {version}
Controls:
- F3: open/close menu
- Escape: close menu
- Enter: go to the selected room
- Tab: toggle case-sensitivity
- Up/Down: navigate the suggested rooms list

Use your keyboard to type the room name/id.

The font ""8bitoperator JVE"" is created by nipcen. 
It can be found at https://fontstruct.com/fontstructions/show/534034/8bitoperator
This font is permitted for use and redistribution under Creative Commons Attribution Share Alike license.
This script is also bound by this license as it uses ""8bitoperator JVE"".
This license can be read at https://creativecommons.org/licenses/by-sa/3.0/legalcode
");

Byte[] bytes = Convert.FromBase64String("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");
File.WriteAllBytes(Path.GetDirectoryName(FilePath) + Path.DirectorySeparatorChar + "8bitoperator_jve.ttf", bytes);
